% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spvim_se.R
\name{spvim_se}
\alias{spvim_se}
\title{Standard error estimate for SPVIM values}
\usage{
spvim_se(ics, idx = 1, gamma = 1, na_rm = FALSE)
}
\arguments{
\item{ics}{the influence function estimates based on the contributions from sampling observations and sampling subsets: a list of length two resulting from a call to \code{spvim_ics}.}

\item{idx}{the index of interest}

\item{gamma}{the proportion of the sample size used when sampling subsets}

\item{na_rm}{remove \code{NA}s?}
}
\value{
The standard error estimate for the desired SPVIM value
}
\description{
Compute standard error estimates based on the estimated influence function for a SPVIM value of interest.
}
\details{
Since the processes for sampling observations and subsets are independent, the variance for a given SPVIM estimator is simply the sum of the vairances based on sampling observations and on sampling subsets.
}
\examples{
\donttest{
## don't test because this can take some time to run
library(SuperLearner)
library(gam)
n <- 100
p <- 2
## generate the data
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

## apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

## generate Y ~ Normal (smooth, 1)
y <- as.matrix(smooth + stats::rnorm(n, 0, 1))

## set up a library for SuperLearner
learners <- c("SL.mean", "SL.gam")

## -----------------------------------------
## using Super Learner
## -----------------------------------------
set.seed(4747)
est <- sp_vim(Y = y, X = x, V = 5,
type = "r_squared",
SL.library = learners, alpha = 0.05)
}

}
\seealso{
\code{\link[vimp]{spvim_ics}} for how the influence functions are estimated.
}
