% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline_functions.R
\name{v_s}
\alias{v_s}
\title{Create splines for use in vglmer}
\usage{
v_s(
  ...,
  type = "tpf",
  knots = NULL,
  by = NA,
  by_re = TRUE,
  force_vector = FALSE,
  outer_okay = FALSE
)
}
\arguments{
\item{...}{Variable name, e.g. \code{v_s(x)}}

\item{type}{Default (\code{"tpf"}) uses truncated linear splines for the
basis. The other option (\code{"o"}) uses O'Sullivan splines (Wand and
Ormerod 2008).}

\item{knots}{Default (\code{NULL}) uses \eqn{K=min(N/4,35)} knots evenly
spaced at quantiles of the covariate \code{x}. A single number specifies a
specific number of knots; a vector can set custom locations for knots.}

\item{by}{A categorical or factor covariate to interact the spline with; for
example, \code{v_s(x, by = g)}.}

\item{by_re}{Default (\code{TRUE}) regularizes the interactions between the
categorical factor and the covariate. See "Details" in \link{vglmer} for
more discussion.}

\item{force_vector}{Force that argument to \code{knots} is treated as vector.
This is usually not needed unless \code{knots} is a single integer that
should be treated as a single knot (vs. the number of knots).}

\item{outer_okay}{Default (\code{FALSE}) does not permit values in \code{x}
to exceed the outer knots.}
}
\value{
This function returns a list of class of \code{vglmer_spline} that is
  passed to unexported functions. It contains the arguments noted above where
  \code{...} is parsed into an argument called \code{term}.
}
\description{
This function estimates splines in \code{vglmer}, similar to \code{s(...)} in
\code{mgcv} albeit with many fewer options than \code{mgcv}. It allows for
truncated (linear) splines or O'Sullivan splines. Please see \link{vglmer}
for more discussion and examples.
}
\references{
Wand, Matt P. and Ormerod, John T. 2008. "On Semiparametric Regression with
O'Sullivan Penalized Splines". \emph{Australian & New Zealand Journal of
Statistics}. 50(2): 179-198.

Wood, Simon N. 2017. \emph{Generalized Additive Models: An Introduction with
R}. Chapman and Hall/CRC.
}
