% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_standard_cev.R
\name{filter_standard_cev}
\alias{filter_standard_cev}
\title{Filter records to replicate results presented in the CEV methodology report.}
\usage{
filter_standard_cev(replicates_data, violation, perp_change = TRUE)
}
\arguments{
\item{replicates_data}{A data frame with data from all replicates to be filtered.}

\item{violation}{Violation to be analyzed. Options are "homicidio", "secuestro",
"reclutamiento", and "desaparicion".}

\item{perp_change}{A logical value indicating whether victims in years after
2016 with perpetrator values (indicated by \code{p_str}) of the FARC-EP ("GUE-FARC")
should be reassigned to other guerrilla groups (\code{p_str} value "GUE-OTRO").}
}
\value{
A filtered data frame.
}
\description{
Filter records to replicate results presented in the CEV methodology report.
}
\examples{
\donttest{
local_dir <- system.file("extdata", "right", package = "verdata")
replicates_data <- read_replicates(local_dir, "reclutamiento", c(1, 2), version = "v1")
filter_standard_cev(replicates_data, "reclutamiento", perp_change = TRUE)
}
}
