% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.spv.R, R/plot.spvforlist.R, R/plot.spvlist.R, R/plot.spvlistforlist.R
\name{plot.spv}
\alias{plot.spv}
\alias{plot.spvforlist}
\alias{plot.spvlist}
\alias{plot.spvlistforlist}
\title{Plot VDGs or FDS plots}
\usage{
\method{plot}{spv}(x, which = c("fds", "vdgsim", "vdgquantile", "vdgboth",
  "boxplots"), np = 50, alpha = 7/sqrt(length(x$spv)),
  points.colour = "#39BEB1", points.size = 2, tau = c(0.05, 0.95),
  radii = 21, hexbin = FALSE, bins = 80, df = 10, lines.size = 1,
  origin = rep(0, ncol(x$sample)), method, arrange = FALSE, ...)

\method{plot}{spvforlist}(x, which = c("fds", "vdgsim", "vdgquantile",
  "vdgboth", "boxplots"), np = 50, alpha = 7/sqrt(length(x[[1]]$spv)),
  points.colour = "#39BEB1", points.size = 2, tau = c(0.05, 0.95),
  radii = 21, hexbin = FALSE, bins = 80, df = 10, lines.size = 1,
  origin = rep(0, ncol(x[[1]]$sample)), method, arrange = FALSE, ...)

\method{plot}{spvlist}(x, which = c("fds", "vdgsim", "vdgquantile", "vdgboth",
  "boxplots"), np = 50, alpha = 7/sqrt(length(x[[1]]$spv)),
  points.colour = "#39BEB1", points.size = 2, tau = c(0.05, 0.95),
  radii = 21, hexbin = FALSE, bins = 80, VRFDS = FALSE, df = 10,
  lines.size = 1, origin = rep(0, ncol(x[[1]]$sample)), method,
  arrange = FALSE, ...)

\method{plot}{spvlistforlist}(x, which = c("fds", "vdgsim", "vdgquantile",
  "vdgboth", "boxplots"), np = 50, alpha = 7/sqrt(length(x[[1]][[1]]$spv)),
  points.colour = "#39BEB1", points.size = 2, tau = c(0.05, 0.95),
  radii = 21, hexbin = FALSE, bins = 80, df = 10, lines.size = 1,
  origin = rep(0, ncol(x[[1]][[1]]$sample)), method, arrange = FALSE, ...)
}
\arguments{
\item{x}{an object of type \code{spv} for a single experimental design or an
object of type \code{spvlist} for multiple designs.}

\item{which}{either a numeric vector of integers or a character vector
indicating which plots to produce. The possible plots are:
\describe{
\item{\code{1} or \code{"fds"}}{A (variance ratio) FDS plot}
\item{\code{2} or \code{"vdgsim"}}{A VDG with only the simulated prediction variance points plotted}
\item{\code{3} or \code{"vdgquantile"}}{A VDG with only the quantile regression lines corresponding to \code{tau} shown}
\item{\code{4} or \code{"vdgboth"}}{A combination of \code{2} and \code{3}}
\item{\code{5} or \code{"boxplots"}}{Parallel boxplots of the prediction variance}
}}

\item{np}{scalar; the number of points to use for calculating the fraction of design space criterion.}

\item{alpha}{the alpha transparency coefficient for the plots}

\item{points.colour}{colour for points in scatterplot of SPV against the radius}

\item{points.size}{size for points in scatterplot of SPV against the radius}

\item{tau}{the tau parameter for \code{\link[quantreg]{rq}} (quantile
regression)}

\item{radii}{either a numeric vector containing the radii to use for
calculating the mean spherical SPV over the spherical design space, or an integer
(length one vector) giving the number of radii to use for calculationg
the mean spherical SPV. If missing, the mean spherical SPV is not used.}

\item{hexbin}{logical indicating whether hexagonal binning should be used to display
density instead of colour transparency}

\item{bins}{argument passed to \code{\link{stat_binhex}} to determine the
number of hexagons used for binning.}

\item{df}{degrees-of-freedom parameter passed to \code{\link{bs}}}

\item{lines.size}{line size passed to \code{\link[ggplot2]{geom_line}}}

\item{origin}{numeric vector specifying the origin of the design space}

\item{method}{optional; passed to \code{\link[proxy]{dist}} to overwrite
defaults of "Euclidean" for spherical regions or "supremum" for cubiodal
regions}

\item{arrange}{Logical indicating whether to return a single graphical object arranging the
resulting plots in a single plot window via \code{\link{grid.arrange}}, or whether to return the
list of graphical objects containing the plots.}

\item{VRFDS}{logical indicating whether to construct a variance ratio FDS plot or not (only for class \code{spvlist}). The
first design is used as reference design in case of \code{VRFDS} is \code{TRUE}}

\item{\dots}{additional arguments passed to \code{\link[proxy]{dist}}}
}
\value{
Returns a list of \code{\link{ggplot2}} graphical objects (or grobs) with names corresponding
to the character version of \code{which}. These plot objects can be manipulated by changing plot
aesthetics and theme elements.
}
\description{
Produce Variance Dispersion Graphs and/or Fraction of Design Space plots for
experimental designs. There are methods for the S3 classes \code{spv},
\code{spvlist}, \code{spvforlist} and \code{spvlistforlist} -- see
\code{\link{spv}}.
}
\examples{
# Single design (class 'spv')
# Larger n should be used in actual cases
library(rsm)
bbd3 <- as.data.frame(bbd(3)[,3:5])
colnames(bbd3) <- paste0("x", 1:3)
quad.3f <- formula(~ x1*x2*x3 - x1:x2:x3 + I(x1^2) + I(x2^2) + I(x3^2))
set.seed(1234)
out <- spv(n = 1000, design = bbd3, type = "spherical", formula = quad.3f)
out
plot(out)

# List of designs (class 'spvlist')
\dontrun{
library(Vdgraph)
data(SCDH5); data(SCDDL5)
des.list <- list(SCDH5 = SCDH5, SCDDL5 = SCDDL5)
quad.5f <- formula(~ x1 + x2 + x3 + x4 + x5 + x1:x2 + x1:x3 + x1:x4 + x1:x5
                    + x2:x3 + x2:x4 + x2:x5 + x3:x4 + x3:x5 + x4:x5
                   + I(x1^2) + I(x2^2) + I(x3^2) + I(x4^2) + I(x5^2))
out2 <- spv(n = 500, design = des.list, type = "spherical", formula = quad.5f)
out2
plot(out2)
}

# List of formulae (class 'spvforlist')
\dontrun{
fact3 <- expand.grid(x1 = c(-1,1), x2 = c(-1, 1), x3 = c(-1,1))
lin.3f <- formula(~ x1 + x2 + x3)
int.3f <- formula(~ (x1+x2+x3)^2)
set.seed(4312)
out3 <- spv(n = 500, design = fact3, type = "cuboidal",
             formula = list(linear = lin.3f, interaction = int.3f))
out3
plot(out3)
}

# List of formulae and designs (class 'spvlistforlist')
\dontrun{
fact3.n <- rbind(fact3, 0, 0, 0)
set.seed(4312)
out4 <- spv(n = 200, design = list(factorial = fact3, factorial.with.cntr = fact3.n),
             type = "cuboidal", formula = list(linear = lin.3f, interaction = int.3f))
out4
plot(out4)
}
}
\author{
Pieter C. Schoonees
}
\keyword{hplot}

