% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_info.R
\name{prediction_info}
\alias{prediction_info}
\title{Create an object with a prediction about the future values of a time series}
\usage{
prediction_info(name, forecast, ...)
}
\arguments{
\item{name}{a character indicating the name of the method used to forecast.}

\item{forecast}{a time series of class \code{ts} or a vector. It is a
prediction for the future values of a time series.}

\item{...}{prediction intervals for the forecast. These prediction intervals
must have been built with the \code{\link[=pi_info]{pi_info()}} function.}
}
\value{
an object of class \code{pred_info}. A list with the information supplied
to the function.
}
\description{
The object created contains a forecast and, optionally, prediction intervals
for the forecast.
}
\examples{
if (require("forecast")) {
  time_series <- ts(rnorm(40))
  f <- meanf(time_series, level = 95)
  info <- prediction_info("mean", f$mean, pi_info(95, f$lower, f$upper))
}
}
\seealso{
\code{\link[=pi_info]{pi_info()}} for how to create prediction intervals.
}
