% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{vec_repeat}
\alias{vec_repeat}
\title{Expand the length of a vector}
\usage{
vec_repeat(x, each = 1L, times = 1L)
}
\arguments{
\item{x}{A vector.}

\item{each}{Number of times to repeat each element of \code{x}.}

\item{times}{Number of times to repeat the whole vector of \code{x}.}
}
\value{
A vector the same type as \code{x} with size \code{vec_size(x) * times * each}.
}
\description{
This is a special case of \code{\link[=rep]{rep()}} for the special case of integer \code{times}
and \code{each} values, and works along size, rather than length.
}
\examples{
# each repeats within
vec_repeat(1:3, each = 2)
# times repeats whole thing
vec_repeat(1:3, times = 2)

df <- data.frame(x = 1:2, y = 1:2)
# rep() repeats columns of data frame, and returns list:
rep(df, each = 2)
# vec_repeat() repeats rows, and returns same data.frame
vec_repeat(df, 2)
}
