% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.ave.cor.over}
\alias{se.ave.cor.over}
\title{Computes the standard error for the average of two Pearson correlations with
one variable in common that have been estimated from the same sample}
\usage{
se.ave.cor.over(cor12, cor13, cor23, n)
}
\arguments{
\item{cor12}{estimated correlation between variables 1 and 2}

\item{cor13}{estimated correlation between variables 1 and 3}

\item{cor23}{estimated correlation between variables 2 and 3}

\item{n}{sample size}
}
\value{
Returns a two-row matrix. The first row gives results for the average
correlation and the second row gives the results with a Fisher
transformation. The columns are:
\itemize{
\item Estimate - estimated average of cor12 and cor13
\item SE - standard error
\item VAR(cor12) - variance of cor12
\item VAR(cor13) - variance of cor13
\item COV(cor12,cor13) - covariance of cor12 and cor13
}
}
\description{
In a study that reports the sample size and three correlations (cor12, cor13,
and cor23 where variable 1 is called the "overlapping" variable), and
variables 2 and 3 are different measurements of the same attribute, this
function can be used to compute the average of cor12 and cor13 and its
standard error. The average correlation and the standard error from this
function can be used as input in the \link[vcmeta]{meta.ave.gen} function
in a meta-analysis where some studies have reported cor12 and other studies
have reported cor13.
}
\examples{
se.ave.cor.over(.462, .518, .755, 100)

# Should return:
#               Estimate         SE  VAR(cor12) VAR(cor13) COV(cor12,cor13)
# Correlation  0.4900000 0.07087351 0.006378045 0.00551907      0.004097553
# Fisher       0.5360603 0.09326690 0.010309278 0.01030928      0.007119936


}
