% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GKgamma.R
\name{GKgamma}
\alias{GKgamma}
\alias{print.GKgamma}
\title{Calculate Goodman-Kruskal Gamma for ordered tables}
\usage{
GKgamma(x, level = 0.95)

\method{print}{GKgamma}(x, digits = 3, ...)
}
\arguments{
\item{x}{A two-way frequency table, in matrix or table form.  The rows and columns are considered to be ordinal factors}

\item{level}{Confidence level for a significance test of \eqn{\gamma \ne =}{gamma !=0}}

\item{digits}{number to digits to use in the print method}

\item{...}{other arguments (unused), for conformity with the print generic}
}
\value{
Returns an object of class \code{"GKgamma"} with 6 components, as follows
\describe{
\item{gamma}{The gamma statistic}
\item{C}{Total number of concordant pairs in the table}
\item{D}{Total number of discordant pairs in the table}
\item{sigma}{Standard error of gamma }
\item{CIlevel}{Confidence level}
\item{CI}{Confidence interval}
}
}
\description{
The Goodman-Kruskal \eqn{\gamma}{gamma} statistic is a measure of
association for ordinal factors in a two-way table proposed by Goodman and
Kruskal (1954).
}
\examples{

data(JobSat)
GKgamma(JobSat)

}
\references{
Agresti, A. \emph{Categorical Data Analysis}. John Wiley & Sons,
2002, pp. 57--59.

Goodman, L. A., & Kruskal, W. H. (1954). Measures of association for cross
classifications. \emph{Journal of the American Statistical Association}, 49,
732-764.

Goodman, L. A., & Kruskal, W. H. (1963). Measures of association for cross
classifications III: Approximate sampling theory. \emph{Journal of the
American Statistical Association}, 58, 310-364.
}
\seealso{
\code{\link[vcd]{assocstats}}, \link[vcd]{Kappa}

Other association tests: 
\code{\link{CMHtest}()},
\code{\link{HLtest}()},
\code{\link{woolf_test}()},
\code{\link{zero.test}()}
}
\author{
Michael Friendly; original version by Laura Thompson
}
\concept{association tests}
\keyword{category}
\keyword{htest}
