% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vaultr.R
\docType{package}
\name{vaultr}
\alias{vaultr}
\title{Vault Client for Secrets and Sensitive Data}
\description{
Vault client for secrets and sensitive data; this package provides
wrappers for HashiCorp's \href{https://vaultproject.io}{vault server}.
The package wraps most of the high-level API, and includes support
for authentication via a number of backends (tokens, username and
password, github, and "AppRole"), as well as a number of secrets
engines (two key-value stores, vault's cubbyhole and the transit
backend for encryption-as-a-service).
}
\details{
To get started, you might want to start with the "vaultr"
vignette, available from the package with \code{vignette("vaultr")}.

The basic design of the package is that it has very few
entrypoints - for most uses one will interact almost entirely with
the \link{vault_client} function.  That function returns an
R6 object with several methods (functions) but also several
objects that themselves contain more methods and objects, creating
a nested tree of functionality.

From any object, online help is available via the help method, for
example

\if{html}{\out{<div class="sourceCode">}}\preformatted{client <- vaultr::vault_client()
client$secrets$transit$help()
}\if{html}{\out{</div>}}

For testing packages that rely on vault, there is support for
creating temporary vault servers; see \code{vaultr::vault_test_server}
and the "packages" vignette.
}
