% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcdina_vb.R
\name{mc_dina}
\alias{mc_dina}
\title{for the multiple-choice deterministic input noisy AND gate (MC-DINA) model.}
\usage{
mc_dina(
  X,
  Q,
  max_it = 500,
  epsilon = 1e-04,
  seed = 123,
  verbose = TRUE,
  delta_0 = NULL,
  a_0 = NULL
)
}
\arguments{
\item{X}{I by J binary matrix, item response data}

\item{Q}{J by (K+2)matrix, Q-matrix for MC-DINA, Column 1: Item number, Column 2: Stem, Column 3 to end: Attributes}

\item{max_it}{The maximum number of iterations (default: 500)}

\item{epsilon}{The convergence tolerance for iterations (default: 1e-4)}

\item{seed}{The seed value (default: 123)}

\item{verbose}{Logical, controls whether to print progress (default: TRUE)}

\item{delta_0}{the value of hyperparameter \eqn{\delta^0} (default: NULL)}

\item{a_0}{the value of hyperparameter \eqn{a^0} (default: NULL)}
}
\value{
A list including:
\describe{
  \item{theta_est}{the estimate of the conditional response probability parameter \eqn{\Theta}}
  \item{theta_sd}{the posterior standard deviation of parameter \eqn{\Theta}}
  \item{pi_est}{the estimates of class mixing parameter \eqn{\pi}}
  \item{pi_sd}{the posterior standard deviations of class mixing parameter \eqn{\pi}}
  \item{a_ast}{the estimate of variational parameter \eqn{a^*}}
  \item{delta_ast}{the estimate of variational parameter \eqn{\delta^*}}
  \item{a_0}{the value of hyperparameter \eqn{a^0}}
  \item{delta_0}{the value of hyperparamter \eqn{\delta^0}}
  \item{l_lb}{the list of the values of evidence lower bound in each itertion}
  \item{att_pat_est}{the estimated attribute mastery patterns}
  \item{G-mat}{the computed G-matrix}
  \item{m}{the number of performed iterations}
  \item{seed}{the entered seed number}
}
}
\description{
\code{mc_dina()} returns variational Bayesian estimates for the MC-DINA model.
}
\examples{
# load a simulated Q-matrix and make simulated data
mc_Q = mc_sim_Q
mc_sim_data = mc_dina_data_gen(Q=mc_Q,I=200)
# fit multiple-choice DINA model
res_mc = mc_dina(X=mc_sim_data$X, Q=mc_Q)

}
\references{
Yamaguchi, K. (2020). Variational Bayesian inference for the
  multiple-choice DINA model. \emph{Behaviormetrika}, 47(1), 159-187.
  \doi{10.1007/s41237-020-00104-w}
}
