% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpers.R
\name{param_summary}
\alias{param_summary}
\title{Calculates summaries for a parameter}
\usage{
param_summary(x, digits = 2, pretty = FALSE, ..., na.rm = TRUE)
}
\arguments{
\item{x}{a data vector to operate on}

\item{digits}{Number of digits to round to for printing}

\item{pretty}{Logical value whether prettified values should be returned.
Defaults to \code{FALSE}.}

\item{na.rm}{Logical whether to remove NA values. Defaults to \code{TRUE}}

\item{\dots}{Additional arguments passed to \code{pval_smartformat}
to control p-value printing.}
}
\value{
.
}
\description{
This function takes a vector of statistics and calculates
several summaries: mean, median, 95% CI, and
the empirical p-value, that is, how many fall on the other
side of zero.
}
\examples{
param_summary(rnorm(100))
param_summary(rnorm(100), pretty = TRUE)
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}

