% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-input.R
\name{vapour_read_raster_raw}
\alias{vapour_read_raster_raw}
\alias{vapour_read_raster_int}
\alias{vapour_read_raster_dbl}
\alias{vapour_read_raster_chr}
\alias{vapour_read_raster_hex}
\title{type safe(r) raster read}
\usage{
vapour_read_raster_raw(
  x,
  band = 1,
  window,
  resample = "nearestneighbour",
  ...,
  sds = NULL,
  native = FALSE,
  set_na = TRUE
)

vapour_read_raster_int(
  x,
  band = 1,
  window,
  resample = "nearestneighbour",
  ...,
  sds = NULL,
  native = FALSE,
  set_na = TRUE
)

vapour_read_raster_dbl(
  x,
  band = 1,
  window,
  resample = "nearestneighbour",
  ...,
  sds = NULL,
  native = FALSE,
  set_na = TRUE
)

vapour_read_raster_chr(
  x,
  band = 1,
  window,
  resample = "nearestneighbour",
  ...,
  sds = NULL,
  native = FALSE,
  set_na = TRUE
)

vapour_read_raster_hex(
  x,
  band = 1,
  window,
  resample = "nearestneighbour",
  ...,
  sds = NULL,
  native = FALSE,
  set_na = TRUE
)
}
\arguments{
\item{x}{data source}

\item{band}{index of which band to read (1-based)}

\item{window}{src_offset, src_dim, out_dim}

\item{resample}{resampling method used (see details)}

\item{...}{reserved}

\item{sds}{index of subdataset to read (usually 1)}

\item{native}{apply the full native window for read, \code{FALSE} by default}

\item{set_na}{specify whether NA values should be set for the NODATA}
}
\value{
atomic vector of the nominated type raw, int, dbl, or character (hex)
}
\description{
These wrappers around \code{\link[=vapour_read_raster]{vapour_read_raster()}} guarantee single vector output of the nominated type.
}
\details{
\verb{*_hex} and \verb{*_chr} are aliases of each other.
}
\examples{
f <- system.file("extdata", "sst.tif", package = "vapour")
vapour_read_raster_int(f, window = c(0, 0, 5, 4))
vapour_read_raster_raw(f, window = c(0, 0, 5, 4))
vapour_read_raster_chr(f, window = c(0, 0, 5, 4))
plot(vapour_read_raster_dbl(f, native = TRUE), pch = ".", ylim = c(273, 300))
}
