% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundWaterEnvironments.R
\name{Mobility}
\alias{Mobility}
\title{Water Molecule Mobility}
\usage{
Mobility(Bvalues, occupancy)
}
\arguments{
\item{Bvalues}{B-value values from the imported PDB file(s)}

\item{occupancy}{Occumpancy values from the imported PDB file(s)}
}
\value{
Vector of mobility values; unitless.
}
\description{
Calculate the mobility values of waters for a structure.
}
\details{
The mobility of waters within a structure is normalization method to
identify the amount of variance an atom has within a structure. In the case
of waters, identified by an oxygen atom without hydrogen atoms, a
water-oxygen atom with a mobility value of 0 is considered rigid and does
not possess variance. The average mobility within a structure has value of
1 while an atom's mobility value of x is considered x-times as mobile as an
average atom.

\deqn{Mobility = \frac{\frac{B-value}{\mu_{B-value}}}{\frac{Occupancy}{\mu_{Occupancy}}}}{Mobility = (B-value/mu B-value)/(Occupancy/mu Occupancy)}

Mobility is calculated using the B-value and occupancy values; these
values are a byproduct of solving the 3D molecular structure from electron
density maps. The mobility values allows us to compare atomic mobility
between molecular structures solved using different structural refinement
methods. Atoms, in this instance water-oxygens, with a mobility value
greater than 2.0 are removed from analysis.

The mobility exclusion value is user defined within the main
\code{\link[=ConservedWaters]{ConservedWaters()}} function but has a default value of 2.0.
}
\examples{
  set.seed(13)
  sample.idc <- sample(1:nrow(thrombin.1hai$atom), 10)
  Bvalues <- thrombin.1hai$atom[sample.idc, "b"]
  Bvalues
  # [1] 45.73 45.40 20.24 39.30 35.53
  #     22.16 35.81 15.35 22.73 21.34
  occupancy <- thrombin.1hai$atom[sample.idc, "o"]
  occupancy
  # [1] 0.01 1.00 1.00 1.00 1.00
  #     1.00 1.00 1.00 1.00 1.00
  Mobility(Bvalues, occupancy)
  # [1] 135.7183 1.3474 0.6007 1.1664 1.0545
  #       0.6577 1.0628 0.4556 0.6746 0.6333

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\seealso{
Other "Bound Water Environment": \code{\link{BoundWaterEnvironment.interact}},
  \code{\link{BoundWaterEnvironment.quality}},
  \code{\link{BoundWaterEnvironment}},
  \code{\link{NormalizedBvalue}}, \code{\link{calcBvalue}},
  \code{\link{calcNearbyHydrationFraction}},
  \code{\link{calcNumHydrogenBonds}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Bound Water Environment"}
