% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{RescaleValues}
\alias{RescaleValues}
\title{Rescale Values}
\usage{
RescaleValues(data, newMin = 0, newMax = 1)
}
\arguments{
\item{data}{A vector of numerical values to be rescaled}

\item{newMin}{A numerical value indicating the new minimum value; default: 0}

\item{newMax}{A numerical value indicating the new maximum value; default: 1}
}
\value{
vector of rescaled numerical values.
}
\description{
Rescales provided vector of values to a user defined range.
}
\details{
Rescale the values to a new user defined range.
}
\examples{
  RescaleValues(0:10, newMin = 0, newMax = 1)
  # [1] 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
