% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{MobNormBvalEvalPlots}
\alias{MobNormBvalEvalPlots}
\title{Mobility and Normalized B-values Evaluation Plots}
\usage{
MobNormBvalEvalPlots(data, passed.waters = TRUE,
  title = "Mobility and Normalized B-value Evaluation")
}
\arguments{
\item{data}{The \code{h2o.clusters.summary} data.frame from the
\code{\link[=ConservedWaters]{ConservedWaters()}} function containing the \code{nBvalue.mu}
information. This data.frame is found within the \code{h2o.cluster.passed}
and \code{h2o.cluster.all}}

\item{passed.waters}{Logical indicator to plot results for waters \strong{passing}
\code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} \emph{\strong{OR}} using \strong{all} waters within
the \code{PDB} files.}

\item{title}{The title for the plot}
}
\description{
Mean bound water environment summary per percent conservation
}
\details{
Constructs a series of scatterplots illustrating the relationship
between mobility and normalized B-values and (i) percent water
conservation, (ii) mean distance between waters in a cluster, and (iii)
mean distance between waters in a cluster and the cluster's centroid. The
dots are colored based on water cluster "percent conservation":
\itemize{
\item \strong{light grey dots}: less than 50\% conservation
\item \strong{dark red dots}: 50\% to 69\% conservations
\item \strong{red dots}: 70\% to 79\% conservation
\item \strong{light blue dots}: 80\% to 89\% conservation
\item \strong{blue dots}: 90\% to 99\% conservation
\item \strong{dark blue dots}: 100\% conservation (all structures contribute to the
water cluster).
}

The mean distance plots will have a column of dots at a distance of 0.0 if
there are clusters composed of a single water molecule. Thus, these
clusters have a zero distance between and to other waters in their cluster
because there are \emph{\strong{no other waters}} in their cluster.

This plot was inspired by Figure 2 of Ogata and Wodak (2002).
}
\examples{
  \dontrun{
  bwe.summary.plot <- MobNormBvalEvalPlots(data=thrombin10.conservedWaters,
                                           passed.waters=TRUE,
                                           title="Mobility and Normalized B-value Evaluation")
  }

}
\references{
Koji Ogata and Shoshana J Wodak. Conserved water molecules in MHC
class-I molecules and their putative structural and functional roles.
\emph{Protein Engineering}, 2002, \strong{15} (\emph{8}), pp 697-705.
\href{http://doi.org/10.1093/protein/15.8.697}{DOI: 10.1093/protein/15.8.697}
\href{http://www.ncbi.nlm.nih.gov/pubmed/12364585}{PMID: 12364585}
}
\seealso{
Other plots: \code{\link{BoundWaterEnvPlots}},
  \code{\link{BoundWaterEnvSummaryPlot}},
  \code{\link{BvalueBarplot.summ}},
  \code{\link{BvalueBarplot}},
  \code{\link{ClusterSummaryPlots}},
  \code{\link{MobilityBarplot.summ}},
  \code{\link{MobilityBarplot}},
  \code{\link{OccupancyBarplot.summ}},
  \code{\link{OccupancyBarplot}},
  \code{\link{nBvalueBarplot}},
  \code{\link{normBvalueBarplot.summ}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
