% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_precision.R
\name{print.verify_precision}
\alias{print.verify_precision}
\title{Print method for verify_precision objects}
\usage{
\method{print}{verify_precision}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{verify_precision}.}

\item{digits}{Number of significant digits to display (default: 3).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Displays verification results including observed vs. claimed precision,
test statistics, and verification outcome.
}
\examples{
set.seed(42)
measurements <- rnorm(25, mean = 100, sd = 3.5)
result <- verify_precision(measurements, claimed_cv = 4, mean_value = 100)
print(result)

}
\seealso{
\code{\link[=summary.verify_precision]{summary.verify_precision()}} for detailed output
}
