% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theorical_comparison.R
\name{.calculate_mean_transition}
\alias{.calculate_mean_transition}
\title{calculate_mean_transition}
\usage{
.calculate_mean_transition(df, version, utilityColumn, stateColumn)
}
\arguments{
\item{df}{Data frame containing the health state and utility data.}

\item{version}{Character string specifying the EQ-5D version ("5L" or "3L").}

\item{utilityColumn}{Character string specifying the column name in `df` containing utility values.}

\item{stateColumn}{Character string specifying the column name in `df` containing health state values.}
}
\value{
A data frame containing the following columns:
  - Columns for each transition (e.g., "MOb", "MOw", "SCb", "SCw", etc.)
  - `baseline_HS`: Baseline health state for each transition.
  - `LSS`: Level Sum Score for the baseline health state.
  - `baseline_utility`: Baseline utility value for each transition.
  - `mean_transition`: Mean of the transitions for each row.
}
\description{
This function calculates the mean transitions for EQ-5D health states based on the version specified.
}
\keyword{internal}
