% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_window.r
\name{bed_window}
\alias{bed_window}
\title{Identify intervals within a specified distance.}
\usage{
bed_window(x, y, genome, ...)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{y}{\link{ivl_df}}

\item{genome}{\link{genome_df}}

\item{...}{params for bed_slop and bed_intersect}
}
\description{
Identify intervals within a specified distance.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 25,     50,
  "chr1", 100,    125
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 60,     75
)

genome <- tibble::tribble(
  ~chrom, ~size,
  "chr1", 125
)

bed_glyph(bed_window(x, y, genome, both = 15))

x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 10, 100,
  "chr2", 200, 400,
  "chr2", 300, 500,
  "chr2", 800, 900
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 150,    400,
  "chr2", 230,    430,
  "chr2", 350,    430
)

genome <- tibble::tribble(
  ~chrom, ~size,
  "chr1", 500,
  "chr2", 1000
)

bed_window(x, y, genome, both = 100)

}
\seealso{
\url{https://bedtools.readthedocs.io/en/latest/content/tools/window.html}

Other multiple set operations: 
\code{\link{bed_closest}()},
\code{\link{bed_coverage}()},
\code{\link{bed_intersect}()},
\code{\link{bed_map}()},
\code{\link{bed_subtract}()}
}
\concept{multiple set operations}
