% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_eps.R
\name{eps}
\alias{eps}
\title{Ensemble of Pruned Set for multi-label Classification}
\usage{
eps(mdata, base.method = getOption("utiml.base.method", "SVM"), m = 10,
  subsample = 0.75, p = 3, strategy = c("A", "B"), b = 2, ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.method}{A string with the name of the base method. (Default:
\code{options("utiml.base.method", "SVM")})}

\item{m}{The number of Pruned Set models used in the ensemble.}

\item{subsample}{A value between 0.1 and 1 to determine the percentage of
training instances that must be used for each classifier. (Default: 0.63)}

\item{p}{Number of instances to prune. All labelsets that occurs p times or
less in the training data is removed. (Default: 3)}

\item{strategy}{The strategy  (A or B) for processing infrequent labelsets.
(Default: A).}

\item{b}{The number used by the strategy for processing infrequent labelsets.}

\item{...}{Others arguments passed to the base method for all subproblems}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{EPSmodel} containing the set of fitted
  models, including:
  \describe{
   \item{rounds}{The number of interations}
   \item{models}{A list of PS models.}
  }
}
\description{
Create an Ensemble of Pruned Set model for multilabel classification.
}
\details{
Pruned Set (PS) is a multi-class transformation that remove the less common
classes to predict multi-label data. The ensemble is created with different
subests of the orignal multi-label data.
}
\examples{
model <- eps(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
##Change default configurations
model <- eps(toyml, "RF", m=15, subsample=0.4, p=4, strategy="B", b=4)
}
}
\references{
Read, J. (2008). A pruned problem transformation method for multi-label
 classification. In Proceedings of the New Zealand Computer Science Research
 Student Conference (pp. 143-150).
}
\seealso{
Other Ensemble methods: \code{\link{ebr}},
  \code{\link{ecc}}

Other Powerset: \code{\link{lp}}, \code{\link{ppt}},
  \code{\link{ps}}, \code{\link{rakel}}

Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{homer}},
  \code{\link{lift}}, \code{\link{lp}}, \code{\link{mbr}},
  \code{\link{ns}}, \code{\link{ppt}},
  \code{\link{prudent}}, \code{\link{ps}},
  \code{\link{rakel}}, \code{\link{rdbr}},
  \code{\link{rpc}}
}

