% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{badges}
\alias{badges}
\alias{use_badge}
\alias{use_cran_badge}
\alias{use_bioc_badge}
\alias{use_lifecycle_badge}
\alias{use_binder_badge}
\title{README badges}
\usage{
use_badge(badge_name, href, src)

use_cran_badge()

use_bioc_badge()

use_lifecycle_badge(stage)

use_binder_badge(ref = git_branch_default(), urlpath = NULL)
}
\arguments{
\item{badge_name}{Badge name. Used in error message and alt text}

\item{href, src}{Badge link and image src}

\item{stage}{Stage of the package lifecycle. One of "experimental",
"stable", "superseded", or "deprecated".}

\item{ref}{A Git branch, tag, or SHA}

\item{urlpath}{An optional \code{urlpath} component to add to the link, e.g.
\code{"rstudio"} to open an RStudio IDE instead of a Jupyter notebook. See the
\href{https://mybinder.readthedocs.io/en/latest/howto/user_interface.html}{binder documentation}
for additional examples.}
}
\description{
These helpers produce the markdown text you need in your README to include
badges that report information, such as the CRAN version or test coverage,
and link out to relevant external resources. To add badges automatically
ensure your badge block starts with a line containing only
\verb{<!-- badges: start -->} and ends with a line containing only
\verb{<!-- badges: end -->}.
}
\details{
\itemize{
\item \code{use_badge()}: a general helper used in all badge functions
\item \code{use_bioc_badge()}: badge indicates \href{https://bioconductor.org/developers/}{BioConductor build status}
\item \code{use_cran_badge()}: badge indicates what version of your package is
available on CRAN, powered by \url{https://www.r-pkg.org}
\item \code{use_lifecycle_badge()}: badge declares the developmental stage of a
package according to \url{https://lifecycle.r-lib.org/articles/stages.html}.
\item \code{use_binder_badge()}: badge indicates that your repository can be launched
in an executable environment on \url{https://mybinder.org/}
}
}
\examples{
\dontrun{
use_cran_badge()
use_lifecycle_badge("stable")
}
}
\seealso{
Functions that configure continuous integration, such as
\code{\link[=use_github_actions]{use_github_actions()}}, also create badges.
}
