% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{use_github}
\alias{use_github}
\title{Connect a local repo with GitHub}
\usage{
use_github(
  organisation = NULL,
  private = FALSE,
  protocol = git_protocol(),
  credentials = NULL,
  auth_token = github_token(),
  host = NULL
)
}
\arguments{
\item{organisation}{If supplied, the repo will be created under this
organisation, instead of the account of the user associated with the
\code{auth_token}. You must have permission to create repositories.}

\item{private}{If \code{TRUE}, creates a private repository.}

\item{protocol}{Optional. Should be "ssh" or "https", if specified. Defaults
to the option \code{usethis.protocol} and, if unset, to an interactive choice
or, in non-interactive sessions, "ssh". \code{NA} triggers the interactive menu.}

\item{credentials}{A git2r credential object produced with
\code{\link[git2r:cred_env]{git2r::cred_env()}}, \code{\link[git2r:cred_ssh_key]{git2r::cred_ssh_key()}}, \code{\link[git2r:cred_token]{git2r::cred_token()}}, or
\code{\link[git2r:cred_user_pass]{git2r::cred_user_pass()}}.}

\item{auth_token}{GitHub personal access token (PAT).}

\item{host}{GitHub API host to use. Override with the endpoint-root for your
GitHub enterprise instance, for example,
"https://github.hostname.com/api/v3".}
}
\description{
\code{use_github()} takes a local project, creates an associated repo on GitHub,
adds it to your local repo as the \code{origin} remote, and makes an initial push
to synchronize. \code{use_github()} requires that your project already be a Git
repository, which you can accomplish with \code{\link[=use_git]{use_git()}}, if needed. See the
Authentication section below for other necessary setup.
}
\section{Authentication}{

A new GitHub repo will be created via the GitHub API, therefore you must
make a \href{https://github.com/settings/tokens}{GitHub personal access token (PAT)} available. You can either
provide this directly via the \code{auth_token} argument or store it for retrieval
with \code{\link[=github_token]{github_token()}}.
}

\examples{
\dontrun{
pkgpath <- file.path(tempdir(), "testpkg")
create_package(pkgpath) # creates package below temp directory
proj_set(pkgpath)

## now, working inside "testpkg", initialize git repository
use_git()

## create github repository and configure as git remote
use_github()
}
}
