% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{get_percentage_of_matches}
\alias{get_percentage_of_matches}
\title{Get percentage of matches between two vectors}
\usage{
get_percentage_of_matches(vec1, vec2)
}
\arguments{
\item{vec1}{numeric vector with \code{names} attribute}

\item{vec2}{numeric vector with \code{names} attribute}
}
\value{
the percentage of common values (exact matches) between the two
vectors. Can only be a value between 0 (no common elements) and 1 (perfect
element match). Note that \emph{NaN} and \emph{NA} values are allowed in
the input vectors, but they will always count as a mismatch.
}
\description{
Use this function on two numeric vectors with the same \code{names} attribute
(columns) and same length, in order to find the percentage of common elements
(value matches between the two vectors). The same \code{names} for the two
vectors ensures that their values are logically matched one-to-one.
}
\examples{
vec1 = c(1, 2, 3, 2)
vec2 = c(20, 2, 2.5, 8)
vec3 = c(1, 2, 333, 222)
names.vec = c(seq(1,4))
names(vec1) = names.vec
names(vec2) = names.vec
names(vec3) = names.vec

match.1.2 = get_percentage_of_matches(vec1, vec2)
match.1.3 = get_percentage_of_matches(vec1, vec3)

}
