% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist_get}
\alias{dist_get}
\title{Retrieve distances from a \code{dist} object.
Check if square
Check if numeric}
\usage{
dist_get(d, idx1, idx2)
}
\arguments{
\item{d}{A distance matrix object of class \code{dist}.}

\item{idx1, idx2}{Indicies specifying the distances to extract.}
}
\value{
A vector of distances.
}
\description{
Retrieve distances from a \code{dist} object.
Check if square
Check if numeric
}
\examples{
m4 <- matrix(1:16, nrow=4, dimnames=list(LETTERS[1:4]))
dm4 <- dist(m4)
dist_get(dm4, "A", "C")
dist_get(dm4, "A", c("A", "B", "C", "D"))
dist_get(dm4, c("A", "B", "C"), c("B", "D", "B"))
}
