% Generated by roxygen2 (4.0.2): do not edit by hand
\name{replace_parameter}
\alias{replace_parameter}
\title{replace the value of an API parameter}
\usage{
replace_parameter(urls, parameter, new_value)
}
\arguments{
\item{urls}{a vector of URLs.}

\item{parameter}{the name of the parameter to search for. Case sensitive (so preprocessing
with \code{\link{tolower}} may be useful).}

\item{new_value}{the value you want to replace the current value of \code{parameter}.}
}
\value{
a character vector containing the amended URLs. In the situation where the parameter is
not present within the URL, the original URL will be returned.
}
\description{
\code{replace_parameter} takes a vector of URLs and replaces the value
associated with a particular URL parameter, with one of your choosing.
}
\details{
As well as component extraction, people can also find it useful to have access
to component replacement - for example, mass-modifying a set of URLs used for API queries
to output JSON rather than XML.

\code{replace_parameter} accepts a vector of URLs, the name of a parameter, and a replacement value.
It then loops through the URLs replacing the existing value held by that parameter with the new one.

In the case that a parameter is present multiple times in a URL, only the first instance will be amended.
In the case that a parameter is not present at all, no change to the URL will be made.
}
\examples{
replace_parameter(urls = "http://google.org/api.php?smstate=all",
                 parameter = "smstate", new_value = "some")
}
\seealso{
\code{\link{extract_parameter}} for extracting, rather than replacing, values.
}

