% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_bsd.R
\name{bitly_bsds_overrides}
\alias{bitly_bsds_overrides}
\title{Branded Short Domains Group Overrides (Premium)}
\usage{
bitly_bsds_overrides(group_id = NA, showRequestURL = F)
}
\arguments{
\item{group_id}{- a required string | A GUID for a Bitly group}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
Retrieves all account overrides matching specified group_guid and bsd query filters.
}
\examples{
\dontrun{
ui <- bitly_user_info(showRequestURL = TRUE)
bsds_over <- bitly_bsds_overrides(group_id = ui$default_group_guid[1])
}

}
\seealso{
\url{https://dev.bitly.com/api-reference/#getOverridesForGroups}
}
