% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_retrieve_metrics_by_referrers_by_domain}
\alias{bitly_retrieve_metrics_by_referrers_by_domain}
\title{Get Metrics for a Bitlink by referrers by domain}
\usage{
bitly_retrieve_metrics_by_referrers_by_domain(
  bitlink = NULL,
  size = 50,
  unit_reference = NULL,
  unit = NULL,
  units = -1,
  showRequestURL = FALSE
)
}
\arguments{
\item{bitlink}{- required, a Bitlink made of the domain and hash}

\item{size}{- string |  Default: 50 | The quantity of items to be be returned}

\item{unit_reference}{- string | An ISO-8601 timestamp, indicating the most recent time for
which to pull metrics. Will default to current time.}

\item{unit}{- string | Default: "day", Enum: "minute" "hour" "day" "week" "month" | A unit of time}

\item{units}{- integer | Default: -1 | An integer representing the time units to
query data for. pass -1 to return all units of time.}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
This endpoint will group referrers metrics about a single Bitlink.
}
\examples{
\dontrun{
bitly_retrieve_metrics_by_referrers_by_domain(bitlink = "bit.ly/DPetrov", unit = "day",
units = -1, size = 100)
}

}
\seealso{
\url{https://dev.bitly.com/api-reference#getMetricsForBitlinkByReferrersByDomains}
}
