% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googl_links.R
\name{googl_UserLinkHistory}
\alias{googl_UserLinkHistory}
\title{Retrieves a list of URLs shortened by the authenticated user.}
\usage{
googl_UserLinkHistory(projection = "FULL", showRequestURL = FALSE)
}
\arguments{
\item{projection}{- an optional (!) information to return : "ANALYTICS_CLICKS" - Returns short
URL click counts. OR "FULL" - Returns full analytics information (default)}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug 
purposes.}
}
\value{
totalItems - is an approximate number of items in the user's entire history.

nextPageToken - is an opaque string you can use to get the next page of history.
It looks a lot like an ISO 8601 formatted date right now, but you should not count on that
being true. The nextPageToken will be present on all but the last page

long_url - items contains the list of entries for the first "page" of the user's history,
in order of descending creation time. The values for each entry are the same as specified in
the Analytics section 
\url{https://developers.google.com/url-shortener/v1/getting_started#url_analytics}.
}
\description{
returns a paginated list of information about short URLs created by a user,
sorted in reverse chronological order. Each returned resource contains the short URL,
long URL, creation timestamp, and status.
}
\note{
Requires that the user authenticates with his google account through OAUTH 2.0 ! Thus no API key is necessary
}
\examples{
\dontrun{
googl_token <- googl_auth(key = "", secret = "")
googl_UserLinkHistory(showRequestURL = TRUE)
googl_UserLinkHistory(projection = "FULL", showRequestURL = TRUE)
}

}
\seealso{
See \url{https://developers.google.com/url-shortener/v1/url/list}

See \url{https://developers.google.com/url-shortener/v1/getting_started#history}
}

