% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_LinksExpand}
\alias{bitly_LinksExpand}
\title{Given a bitly URL or hash (or multiple), returns the target (long) URL.}
\usage{
bitly_LinksExpand(hashIN = NULL, shortUrl = NULL, showRequestURL = FALSE)
}
\arguments{
\item{hashIN}{- refers to one bitly hashes, (e.g.:  2bYgqR or a-custom-name). Required}

\item{shortUrl}{- refers to one Bitlinks e.g.: http://bit.ly/1RmnUT or http://j.mp/1RmnUT. 
Optional.}

\item{showRequestURL}{- show URL which has been build and requested from server. 
For debug purposes.}
}
\value{
short_url - this is an echo back of the shortUrl request parameter.

hash - this is an echo back of the hash request parameter.

user_hash - the corresponding bitly user identifier.

global_hash - the corresponding bitly aggregate identifier.

error - indicates there was an error retrieving data for a given shortUrl or hash. An 
example error is "NOT_FOUND".

long_url - the URL that the requested short_url or hash points to.
}
\description{
See \url{http://dev.bitly.com/links.html#v3_expand}
}
\note{
Either shortUrl or hash must be given as a parameter.

The maximum number of shortUrl and hash parameters is 15.
}
\section{TODO}{
 or more URLs  Up TO 15
}
\examples{
\dontrun{ 
bitly_token <- bitly_auth(key = "be03aead58f23bc1aee6e1d7b7a1d99d62f0ede8", 
secret = "b7e4abaf8b26ec4daa92b1e64502736f5cd78899")
bitly_LinksExpand(shortUrl = "http://bit.ly/DPetrov")
bitly_LinksExpand(hash = "DPetrov", showRequestURL = TRUE) 
bitly_LinksExpand(hash = "DPetrov")
bitly_LinksExpand(shortUrl = "on.natgeo.com/1bEVhwE", hash = "1bEVhwE")

## manyHashes <- list("DPetrov", "1QU8CFm", "1R1LPSE", "1LNqqva")
## for (u in 1:length(manyHashes)) {
##   print(bitly_LinksExpand(hashIN = manyHashes[[u]], showRequestURL = TRUE))
## }
}

}

