% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_userMetrics.R
\name{bitly_UserMetricsPopularLinks}
\alias{bitly_UserMetricsPopularLinks}
\title{Returns the authenticated user's most-clicked Bitlinks (ordered by number of clicks) in 
a given time period.}
\usage{
bitly_UserMetricsPopularLinks(limit = 1000, unit = c("minute", "hour",
  "day", "week", "month"), units = -1, showRequestURL = FALSE)
}
\arguments{
\item{limit}{- 1 to 1000 (default=1000).}

\item{unit}{- minute, hour, day, week or month, default: day; Note: when unit is minute the 
maximum value for units is 60.}

\item{units}{- an integer representing the time units to query data for. Pass -1 to return all 
units of time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug 
purposes.}
}
\value{
link - a Bitlink.

clicks - the number of clicks on that Bitlink in the specified timeframe.
}
\description{
See \url{http://dev.bitly.com/user_metrics.html#v3_user_popular_links}
}
\note{
This has replaced the realtime_links endpoint.
}
\examples{
\dontrun{
bitly_token <- bitly_auth(key = "", secret = "")
bitly_UserMetricsPopularLinks(unit = "day", units = -1, limit = 100)
}

}

