% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_card.R
\name{create_card_from_excel}
\alias{create_card_from_excel}
\title{Create a new card on a specified UpWave board}
\usage{
create_card_from_excel(excel_file, sheet, line_number, organisation, board_id,
  board_name, token)
}
\arguments{
\item{excel_file}{A character. The path to an excel-file providing informations for user-stories;
expected columns: US-ID, name, description}

\item{sheet}{An integer or a character. The sheet of the excel-file providing informations for user-stories;
expected columns: US-ID, name, description}

\item{line_number}{An integer. The line number in the spreadsheet starting from 0 --> SLC: Why not 1?!}

\item{organisation}{A character. The name of the organisation as specified in the URL:
https://<organisation>.upwave.io}

\item{board_id}{An integer. The board number, the card has to be created in}

\item{board_name}{A character. The board name, the card has to be created in}

\item{token}{A character. The API token to access boards on upwave.io. The token can be
obtained by visiting your account settings. Click your profile image, select "Settings"
and find your API-Key in the "Account" tab.}
}
\description{
create_card_from_excel() adds a new card in the most-left column of the given board.
The Information of the card are taken from an excel file.
}
\examples{
\dontrun{create_card_from_excel(excel_file = "path_to_your_excel_file", sheet = (sheetno. or sheetname),
line_number = linenr, organisation = "your_organisation", board_id = your_board_id,
board_name = "your_board_name", "token = your_api_token")}
}
