% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{convert_str_to_logical}
\alias{convert_str_to_logical}
\title{Converts a character vector to logicals}
\usage{
convert_str_to_logical(
  x,
  truthy = c("T", "TRUE", "Y", "YES"),
  falsy = c("F", "FALSE", "N", "NO")
)
}
\arguments{
\item{x}{A character vector.}

\item{truthy}{A vector of case-insensitive truthy values to turn into TRUE.}

\item{falsy}{A vector of case-insensitive falsy values to turn into FALSE.}
}
\value{
A logical vector.
}
\description{
Takes a character vector and converts it to logicals, optionally using
a vector of patterns to match against for truthy and falsy values.
}
\examples{
convert_str_to_logical(c('YES', 'Y', 'No', 'N', 'YES', 'yes', 'no', 'Yes', 'NO', 'Y', 'y'))

}
