% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{obj_for_rho}
\alias{obj_for_rho}
\title{Objective function when updating a single inbreeding coefficient.}
\usage{
obj_for_rho(rho, mu, sigma2, alpha, log_bb_dense, ploidy)
}
\arguments{
\item{rho}{The inbreeding coefficient for the individual.}

\item{mu}{A vector of posterior means. The jth element is the
posterior mean of SNP j for the individual.}

\item{sigma2}{A vector of posterior variances. The jth element
is the posterior variance of SNP j for the individual.}

\item{alpha}{A vector of allele frequencies. The jth element
is the allele frequency for SNP j.}

\item{log_bb_dense}{A matrix of log posterior densities. The
rows index the SNPs and the columns index the dosage.}

\item{ploidy}{The ploidy of the species.}
}
\value{
A double. The objective when updating 
    \code{rho} in \code{\link{mupdog}}.
}
\description{
Objective function when updating a single inbreeding coefficient.
}
\author{
David Gerard
}
