% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad.R
\name{pad}
\alias{pad}
\title{Pad a bag of cells with blanks}
\usage{
pad(cells, rows = cells$row, cols = cells$col)
}
\arguments{
\item{cells}{Data frame, the cells to pad}

\item{rows}{Numeric vector, the rows to be padded (existing cells will never
be discarded, e.g. if this is 0, and no gaps will be left even if this is
outside the original range of rows)}

\item{cols}{Numeric vector, the columns to be padded (existing cells will
never be discarded, e.g. if this is 0, and no gaps will be left even if this
is outside the original range of columns)}
}
\description{
When source data is sparse (e.g. spreadsheets from the 'tidyxl'
package), the output of \code{\link{tidytable}} may also be sparse.  To fill
the gaps with blank cells, use \code{pad}.  Internally, \code{pad} is used to
ensure that functions like \code{\link{offset}} and \code{\link{extend}}
behave intuitively, as though blank cells do actually exist.
}
\examples{
cells <- 
  tidytable(purpose$`NNW WNW`, FALSE, FALSE) \%>\% 
  dplyr::filter(!is.na(character)) # Introduce 'holes' in the data
# Select a region with gaps
(bag <- dplyr::filter(cells, row \%in\% 2:4, col \%in\% 1:2))
# Pad the gaps
pad(bag) # By default, the selection is squared-off to its width and height
pad(bag, 0, 0) # Zeros are equivalent to the defaults
pad(bag, 2:5, 1:3) # Add a row and a column
pad(bag, 6, 4) # No gaps are left even when .rows or .cols are distant
}
