% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{loglike_unitquantreg}
\alias{loglike_unitquantreg}
\title{Log-likelihood, score vector and hessian matrix.}
\usage{
loglike_unitquantreg(par, tau, family, linkobj, linkobj.theta, X, Z, y)
}
\arguments{
\item{par}{vector of regression model coefficients for \eqn{\mu} and/or
\eqn{\theta}.}

\item{tau}{quantile level, value between 0 and 1.}

\item{family}{specify the distribution family name.}

\item{linkobj, linkobj.theta}{a function, usually obtained from
\code{\link{make.link}} for link function of \eqn{\mu} and \eqn{\theta},
respectively.}

\item{X}{design matrix related to the \eqn{\mu} parameter.}

\item{Z}{design matrix related to the \eqn{\theta} parameter.}

\item{y}{vector of response variable.}
}
\description{
Internal functions using in \code{\link[unitquantreg]{unitquantreg.fit}}
to compute the negative log-likelihood function, the score vector and the hessian
matrix using analytic expressions written in \code{C++}.
}
