% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.unitquantreg}
\alias{predict.unitquantreg}
\title{Prediction method for \code{unitquantreg} class}
\usage{
\method{predict}{unitquantreg}(
  object,
  newdata,
  type = c("link", "quantile", "shape", "terms"),
  interval = c("none", "confidence"),
  level = 0.95,
  se.fit = FALSE,
  ...
)
}
\arguments{
\item{object}{fitted model object of class \code{\link{unitquantreg}}.}

\item{newdata}{optionally, a data frame in which to look for variables with
which to predict. If omitted, the original observations are used.}

\item{type}{character indicating type of predictions. The options are
\code{link}, \code{quantile}, \code{shape} and \code{terms}.}

\item{interval}{type of interval desired. The options are \code{none} and
\code{confidence}. The "\code{terms}" option returns a matrix giving
the fitted values of each term in the model formula on the linear predictor
scale.}

\item{level}{coverage probability for the confidence intervals. Default is
\code{0.95}.}

\item{se.fit}{logical. If \code{TRUE} return the asymptotic standard errors.}

\item{...}{currently not used.}
}
\value{
If \code{se.fit = FALSE} then returns a \code{data.frame} with
predict values and confidence interval if \code{interval = TRUE}.

If \code{se.fit = TRUE} returns a list with components:
\item{fit}{Predictions, as for \code{se.fit = FALSE}.}
\item{se.fit}{Estimated standard errors.}

For \code{type = "terms"} the output is a \code{data.frame} with a columns
per term.
}
\description{
Extract various types of predictions from unit quantile regression models.
}
\author{
André F. B. Menezes
}
