% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.unitquantregs}
\alias{plot.unitquantregs}
\title{Plot method for \code{unitquantregs} objects}
\usage{
\method{plot}{unitquantregs}(
  x,
  which = c("coef", "conddist"),
  output_df = FALSE,
  parm = NULL,
  level = 0.95,
  mean_effect = FALSE,
  mfrow = NULL,
  mar = NULL,
  ylim = NULL,
  main = NULL,
  col = gray(c(0, 0.75)),
  border = NULL,
  cex = 1,
  pch = 20,
  type = "b",
  xlab = bquote("Quantile level (" * tau * ")"),
  ylab = "Estimate effect",
  dist_type = c("density", "cdf"),
  at_avg = TRUE,
  at_obs = NULL,
  legend_position = "topleft",
  ...
)
}
\arguments{
\item{x}{fitted model object of class \code{unitquantregs}.}

\item{which}{character. Indicate the type of plot. Currently supported are \code{"coef"} which
provide the estimated coefficients for several quantiles and \code{"conddist"} which provide
the conditional distribution (cdf or pdf) at specific values of covariates.}

\item{output_df}{logical. Should \code{data.frame} used to plot be returned?}

\item{parm}{a specification of which parameters are to be plotted, either a vector
of numbers or a vector of names. By default, all parameters are considered.}

\item{level}{level of significance for the confidence interval of parameters.}

\item{mean_effect}{logical. Should a line for the mean effect coefficients be added?}

\item{mfrow, mar, ylim, main, col, border, cex, pch, type, xlab, ylab}{graphical parameters.}

\item{dist_type}{character. Which conditional distribution should be plotted?
The options are \code{"density"} or \code{"cdf"}.}

\item{at_avg}{logical. Should consider the conditional distribution at average values of covariates?}

\item{at_obs}{list. List with name and values for each covariate.}

\item{legend_position}{character. The legend position argument used in \code{legend} function.}

\item{...}{other parameters to be passed through to plotting functions.}
}
\value{
If \code{output_df = TRUE} then returns a data.frame used to plot.
Otherwise, no return value, called for side effects.
}
\description{
Provide two type of plots for \code{unitquantregs} objects.
}
\details{
The plot method for \code{unitquantregs} objects is inspired in PROC QUANTREG of SAS/STAT.
This plot method provide two type of visualizations.

If \code{which = "coef"} plot the estimated coefficients for several quantiles.

If \code{which = "conddist"} plot the conditional distribution at specific values of
covariates. The conditional distribution could be the cumulative distribution function
if \code{dist_type = "cdf"} or the probability density function if \code{dist_type = "pdf"}.
}
\seealso{
\code{\link{plot.unitquantreg}}.
}
\author{
André F. B. Menezes
}
