% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnp.R
\name{hnp}
\alias{hnp}
\alias{hnp.unitquantreg}
\title{(Half-)Normal probability plots with simulated envelopes for
\code{\link{unitquantreg}} objects}
\usage{
hnp(object, ...)

\method{hnp}{unitquantreg}(
  object,
  nsim = 99,
  halfnormal = TRUE,
  plot = TRUE,
  output = TRUE,
  level = 0.95,
  resid.type = c("quantile", "cox-snell"),
  ...
)
}
\arguments{
\item{object}{fitted model object of class \code{\link{unitquantreg}}.}

\item{...}{currently not used.}

\item{nsim}{number of simulations used to compute envelope. Default is 99.}

\item{halfnormal}{logical. If \code{TRUE}, a half-normal plot is produced.
If \code{FALSE}, a normal plot is produced.}

\item{plot}{Should the (half-)normal plot be plotted? Default is \code{TRUE}.}

\item{output}{Should the output be returned? Default is \code{TRUE}.}

\item{level}{confidence level of the simulated envelope. Default is 0.95.}

\item{resid.type}{type of residuals to be used. The default is \code{quantile}.
See \code{\link{residuals.unitquantreg}} for further details.}
}
\value{
A list with the following components in ordered
(and absolute if \code{halfnormal} is \code{TRUE}) values:
\item{obs}{the observed residuals.}
\item{teo}{the theoretical residuals.}
\item{lower}{lower envelope band.}
\item{median}{median envelope band.}
\item{upper}{upper envelope band.}
\item{time_elapsed}{time elapsed to fit the \code{nsim} models.}
}
\description{
Produces a (half-)normal probability plot from a fitted model
object of class \code{\link{unitquantreg}}.
}
\details{
Residuals plots with simulated envelope were proposed by Atkinson (1981)
and can be construct as follows:

\enumerate{
\item{generate sample set of \eqn{n} independent observations from the estimated
parameters of the fitted model;}
\item{fit the model using the generated sample, if \code{halfnormal} is
\code{TRUE} compute the absolute values of the residuals and arrange them in order;}
\item{repeat steps (1) and (2) \code{nsim} number of times;}
\item{consider the \eqn{n} sets of the \code{nsim} ordered statistics
of the residuals, then for each set compute the quantile \code{level}/2,
the median and the quantile 1 - \code{level}/2;}
\item{plot these values and the ordered residuals of the original sample set
versus the expected order statistics of a (half)-normal distribution,
which is approximated as}
\deqn{G^{-1} \left(\frac{i + n - 0.125}{2n + 0.5} \right)}
for half-normal plots, i.e., \code{halfnormal=TRUE} or
\deqn{G^{-1} \left(\frac{i - 0.375}{n + 0.25}\right)}
for normal plots, i.e., \code{halfnormal=FALSE}, where \eqn{G(\cdot)} is the the
cumulative distribution function of standard Normal distribution for
\code{quantile} residuals or the standard exponential distribution for the
\code{cox-snell} residuals.
}

According to Atkinson (1981), if the model was correctly specified then no
more than \code{level}100\% of the observations are expected to appear
outside the envelope bands. Additionally, if a large proportion of the
observations lies outside the envelope, thus one has evidence against
the adequacy of the fitted model.
}
\references{
Atkinson, A. C., (1981). Two graphical displays for outlying and influential observations in regression. \emph{Biometrika} \bold{68}(1), 13--20.
}
\seealso{
\code{\link{residuals.unitquantreg}}
}
\author{
André F. B. Menezes
}
