% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun.R
\name{grepal}
\alias{grepal}
\title{Get a vector of colors whose names match a regular expression.}
\usage{
grepal(pattern, x = colors(), ignore_case = TRUE)
}
\arguments{
\item{pattern}{A regular expression 
(specified as a string/character object).}

\item{x}{A vector of R color names or a data frame of named colors
(i.e., whose names can be searched). 
Default: \code{x = colors()}.}

\item{ignore_case}{Should the case of pattern be ignored 
(passed to \code{ignore.case} of the \code{grep} function)?   
Default: \code{ignore_case = TRUE}.}
}
\description{
\code{grepal} returns a vector of colors whose names match a regular expression (regex).
}
\details{
By default, the base R vector of named colors (i.e., \code{colors()}) is searched 
for names matching a \code{pattern} (which can be a simple string or regular expression). 

If \code{x} (i.e., the object to be searched) is provided, 
it is must be a vector of color names or a data frame of named color objects 
(e.g., a color palette). 

The name \code{grepal} is an abbreviation of \code{grep} and "pal".
}
\examples{
grepal("cyan")

# With regular expressions:
some_grey  <- grepal("gr(a|e)y")
start_grey <- grepal("^gr(a|e)y")
only_grey  <- grepal("^gr(a|e)y$")

length(some_grey)
length(only_grey)

# With other color objects (df as x):
grepal("blau", x = pal_unikn)
grepal("SEE", x = pal_unikn_pref)

# Applications:
seecol(grepal("white"), col_bg = "lightblue2", title = "See 'white' colors()")

olives  <- grepal("olive")
oranges <- grepal("orange")
seecol(list(olives, oranges), 
       pal_names = c("olives", "oranges"), 
       title = "Comparing olives and oranges")

seecol(grepal("SEE", pal_unikn), title = "All 'SEE' colors in pal_unikn")
seecol(grepal("blau", pal_unikn_pref), title = "All 'blau' colors in pal_unikn_pref")

}
\seealso{
\code{\link{defpal}} to define color palettes; 
\code{\link{seepal}} to plot color palettes;  
\code{\link{usecol}} to use a color palette.

Other color functions: 
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{usecol}()}
}
\concept{color functions}
