% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_light.R
\name{add_light}
\alias{add_light}
\title{Add a light to a Unity scene}
\usage{
add_light(
  script,
  light_type = c("Directional", "Point", "Spot", "Area"),
  method_name = NULL,
  light_name = "Light",
  x_position = 0,
  y_position = 0,
  z_position = 0,
  x_scale = 1,
  y_scale = 1,
  z_scale = 1,
  x_rotation = 50,
  y_rotation = -30,
  z_rotation = 0,
  exec = TRUE
)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{light_type}{One of "Directional", "Point", "Spot", or "Area". See
\url{https://docs.unity3d.com/Manual/Lighting.html} for more information.}

\item{method_name}{The internal name to use for the C# method created. Will
be randomly generated if not set.}

\item{light_name}{The name to assign the Light object.}

\item{x_position, y_position, z_position}{The position of the GameObject in
world space.}

\item{x_scale, y_scale, z_scale}{The scale of the GameObject (relative to its
parent object).}

\item{x_rotation, y_rotation, z_rotation}{The rotation of the GameObject to
create, as Euler angles.}

\item{exec}{Logical: Should the C# method be included in the set executed by
MainFunc?}
}
\value{
The \code{unifir_script} object passed to \code{script}, with props for adding
lights appended.
}
\description{
This function creates light objects within a Unity scene. This function can
only add one light at a time -- call the function multiple times to add
more than one light.
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script", unity = waiver())

# Now add props:
script <- add_light(script)

# Lastly, execute the script via the `action` function

}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_prop}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}
}
\concept{props}
