% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Glasgow.R
\docType{data}
\name{glasgow_1}
\alias{glasgow_1}
\title{Primary colors of the University of Glasgow, Scotland}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on 
\href{https://www.gla.ac.uk/myglasgow/staff/brandtoolkit/brandelements/colours/}{UGlasgow's website}.
}
\usage{
glasgow_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{glasgow_1} provides the 12 primary colors 
of the \href{https://www.gla.ac.uk/}{University of Glasgow}, Scotland.
}
\details{
The 12 primary colors are
\code{"glasgow_university_blue"} (defined as HEX #003865),
\code{"glasgow_burgundy"} (defined as HEX #7D2239),
\code{"glasgow_cobalt"} (defined as HEX #005C8A),
\code{"glasgow_lavender"} (defined as HEX #5B4D94),
\code{"glasgow_leaf"} (defined as HEX #006630),
\code{"glasgow_moss"} (defined as HEX #385A4F),
\code{"glasgow_pillarbox"} (defined as HEX #B30C00),
\code{"glasgow_rust"} (defined as HEX #9A3A06),
\code{"glasgow_sandstone"} (defined as HEX #52473B),
\code{"glasgow_sky_blue"} (defined as HEX #005398),
\code{"glasgow_slate"} (defined as HEX #4F5961), and
\code{"glasgow_thistle"} (defined as HEX #951272).

\code{glasgow_1} uses the HEX color definitions.
}
\examples{
 
glasgow_1
unikn::seecol(glasgow_1, main = "University of Glasgow 1") # view color palette

}
\seealso{
\code{\link{glasgow_2}} for secondary colors of the University of Glasgow;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university of color palettes: 
\code{\link{glasgow_2}},
\code{\link{minnesotatwin_1}}
}
\author{
\strong{unicol}, 2023-07-05.
}
\concept{university of color palettes}
\keyword{datasets}
