% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pclm_graphics.R
\name{plot.pclm2D}
\alias{plot.pclm2D}
\title{Generic Plot for pclm2D Class}
\usage{
\method{plot}{pclm2D}(
  x,
  type = c("fitted", "observed"),
  colors = c("#b6e3db", "#e5d9c2", "#b5ba61", "#725428"),
  nbcol = 25,
  xlab = "x",
  ylab = "y",
  zlab = "values",
  phi = 30,
  theta = 210,
  border = "grey50",
  ticktype = "simple",
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{pclm2D}}.}

\item{type}{chart type. Defines which data are plotted, \code{"fitted"} 
values or \code{"observed"} input data. Default: \code{"fitted"}.}

\item{colors}{colors to interpolate; must be a valid argument to
    \code{\link[grDevices]{col2rgb}()}.}

\item{nbcol}{dimension of the color palette. Number of colors. Default: 25.}

\item{xlab}{titles for the axes.  N.B. These must be
    character strings; expressions are not accepted.  Numbers will be
    coerced to character strings.}

\item{ylab}{titles for the axes.  N.B. These must be
    character strings; expressions are not accepted.  Numbers will be
    coerced to character strings.}

\item{zlab}{titles for the axes.  N.B. These must be
    character strings; expressions are not accepted.  Numbers will be
    coerced to character strings.}

\item{phi}{angles defining the viewing direction.
    \code{theta} gives the azimuthal direction and \code{phi}
    the colatitude.}

\item{theta}{angles defining the viewing direction.
    \code{theta} gives the azimuthal direction and \code{phi}
    the colatitude.}

\item{border}{the color of the line drawn around the surface facets.
    The default, \code{NULL}, corresponds to \code{par("fg")}.
    A value of \code{NA} will disable the drawing of borders: this is
    sometimes useful when the surface is shaded.}

\item{ticktype}{character: \code{"simple"} draws just an arrow
    parallel to the axis to indicate direction of increase;
    \code{"detailed"} draws normal ticks as per 2D plots.}

\item{...}{any other argument to be passed to 
\code{\link[graphics]{persp}}.}
}
\description{
The generic plot for a \code{pclm2D} object is constructed using 
\code{\link[graphics]{persp}} method.
}
\examples{
# See complete examples in pclm2D help page
}
\seealso{
\code{\link{pclm2D}}
}
