% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undid_stage_two.r
\name{undid_stage_two}
\alias{undid_stage_two}
\title{Runs UNDID stage two procedures}
\usage{
undid_stage_two(
  empty_diff_filepath,
  silo_name,
  silo_df,
  time_column,
  outcome_column,
  silo_date_format = NULL,
  consider_covariates = TRUE,
  filepath = tempdir(),
  anonymize_weights = FALSE,
  anonymize_size = 5
)
}
\arguments{
\item{empty_diff_filepath}{A character filepath to the \code{empty_diff_df.csv}.}

\item{silo_name}{A character indicating the name of the local silo. Ensure
spelling is the same as it is written in the \code{empty_diff_df.csv}.}

\item{silo_df}{A data frame of the local silo's data. Ensure any covariates
are spelled the same in this data frame as they are in the
\code{empty_diff_df.csv}.}

\item{time_column}{A character which indicates the name of the column in
the \code{silo_df} which contains the date data. Ensure the \code{time_column}
references a column of character values.}

\item{outcome_column}{A character which indicates the name of the column in
the \code{silo_df} which contains the outcome of interest. Ensure the
\code{outcome_column} references a column of numeric values.}

\item{silo_date_format}{A character which indicates the date format which
the date strings in the \code{time_column} are written in.}

\item{consider_covariates}{An optional logical parameter which if set to
\code{FALSE} ignores any of the computations involving the covariates.
Defaults to \code{TRUE}.}

\item{filepath}{Character value indicating the filepath to
save the CSV files. Defaults to \code{tempdir()}.}

\item{anonymize_weights}{A logical value (defaults \code{FALSE}) which
determines if the counts of n (# of obs. used to calculate a
contrast/difference) and n_t (# of treated obs. used in the
calculation of a contrast/difference) should be rounded.}

\item{anonymize_size}{A numeric value. Counts will be rounded to the nearest
multiple of this value if \code{anonymize_weights} is \code{TRUE} (with a minimum
value for any count being set as the value given for \code{anonymize_size}).}
}
\value{
A list of data frames. The first being the filled differences
data frame, and the second being the trends data data frame. Use
the suffix $diff_df to access the filled differences data frame, and
use $trends_data to access the trends data data frame.
}
\description{
Based on the information given in the received \code{empty_diff_df.csv},
computes the appropriate differences in mean outcomes at the local silo
and saves as \code{filled_diff_df_$silo_name.csv}. Also stores trends data
as \code{trends_data_$silo_name.csv}.
}
\details{
Covariates at the local silo should be renamed to match the
spelling used in the \code{empty_diff_df.csv}.
}
\examples{
# Load data
silo_data <- silo71
empty_diff_path <- system.file("extdata/staggered", "empty_diff_df.csv",
                               package = "undidR")

# Run `undid_stage_two()`
results <- undid_stage_two(
  empty_diff_filepath = empty_diff_path,
  silo_name = "71",
  silo_df = silo_data,
  time_column = "year",
  outcome_column = "coll",
  silo_date_format = "yyyy"
)

# View results
head(results$diff_df)
head(results$trends_data)

# Clean up temporary files
unlink(file.path(tempdir(), c("diff_df_71.csv",
                             "trends_data_71.csv")))
}
