% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/torsion.R
\name{torsion}
\alias{torsion}
\title{Computes the Minimum Torsion Matrix}
\usage{
torsion(sigma, model = "minimum-torsion", method = "exact", max_niter = 10000L)
}
\arguments{
\item{sigma}{A \code{n x n} covariance matrix.}

\item{model}{One of: "pca" or "minimum-torsion".}

\item{method}{One of: "approximate" or "exact". Only used when \code{model = "minimum-torsion"}.}

\item{max_niter}{An \code{integer} with the maximum number of iterations.}
}
\value{
A \code{n x n} torsion matrix.
}
\description{
Computes the Principal Components Torsion and the Minimum Torsion
for diversification analysis.
}
\examples{
# extract the invariants from the data
set.seed(123)
log_ret <- matrix(rnorm(400), ncol = 4) / 10

# calculate the covariance matrix
sigma <- stats::cov(log_ret)

# torsion
torsion(sigma = sigma, model = 'minimum-torsion', method ='exact')
}
