% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_rename_file}
\alias{umx_rename_file}
\title{Rename files}
\usage{
umx_rename_file(
  findStr = "old",
  replaceStr = NA,
  baseFolder = "Finder",
  test = TRUE,
  ignoreSuffix = TRUE,
  listPattern = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{findStr}{The pattern to find, i.e., "cats"}

\item{replaceStr}{The replacement pattern "\1 are not dogs"}

\item{baseFolder}{Folder to search in. Default ("Finder") will use the current front-most Finder window (on MacOS).
Set to NA for a "choose folder" dialog.}

\item{test}{Boolean determining whether to change files on disk, or just report on what would have happened (Defaults to test = TRUE)}

\item{ignoreSuffix}{Whether to ignore (don't search in) the suffix (file-type like .mpg) TRUE.}

\item{listPattern}{A pre-filter for files}

\item{overwrite}{Boolean determining if an existing file will be overwritten (Defaults to the safe FALSE)}
}
\value{
None
}
\description{
Rename files. On OS X, the function can access the current front-most Finder window.
The file renaming is fast and, because you can use regular expressions too change names.
}
\examples{
\dontrun{
# "Season 01" --> "S01" in current folder in MacOS Finder
umx_rename_file("[Ss]eason +([0-9]+)", replaceStr="S\\\\1", test = TRUE)

# move date to end of file name
umx_rename_file("^(.*) *([0-9]{2}\\\\.[0-9]{2}\\\\.[0-9]+) *(.*)", replaceStr="\\\\1 \\\\3 \\\\2")

}
}
\seealso{
Other File Functions: 
\code{\link{dl_from_dropbox}()},
\code{\link{umx_file_load_pseudo}()},
\code{\link{umx_make_sql_from_excel}()},
\code{\link{umx_move_file}()},
\code{\link{umx_open}()},
\code{\link{umx_write_to_clipboard}()},
\code{\link{umx}}
}
\concept{File Functions}
