% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_fit_umxFitIndices.R
\name{umxFitIndices}
\alias{umxFitIndices}
\title{Get additional fit-indices for a model with umxFitIndices}
\usage{
umxFitIndices(model, ...)
}
\arguments{
\item{model}{The \code{\link{mxModel}} for which you want fit indices.}

\item{...}{Additional parameters passed to \code{\link{summary.MxModel}}.}
}
\value{
List of fit statistics
}
\description{
Computes a variety of fit indices. Originated in this thread: \url{http://openmx.ssri.psu.edu/thread/765}
}
\details{
Note: This function is currently not robust across multi-group designs or
definition variables. It is designed to provide residual-based fit indices
(SRMR, CRMR, SMAR, CMAR, etc.) and less-often reported fit indices where
Reviewer 2 wants something other than CFA/TLI/RMSEA.

Fit information reported includes:

\strong{Model characteristics}:
numObs, estimated parameters,
observed statistics, observed summary statistics,
-2*log(Likelihood), degrees of freedom

\strong{Chi-squared test}:
Chi, ChiDoF, p (of Chi), ChiPerDoF,

\strong{Noncentrality-based indices}:
RMSEA, RMSEACI, RMSEANull, RMSEAClose (p value), independenceRMSEA,
NCP, NCPCI, F0, F0CI, Mc (aka NCI, MFI)

\strong{Comparative fit indices}:
TLI (aka NNFI), CFI, IFI, PRATIO, PCFI

\strong{Residual-based indices}:
RMR, SRMR, SRMR_mplus, CRMR,
MAR, SMAR, SMAR_mplus, CMAR

\strong{Information-theory criteria} (computed using chi-square or -2LL; df or parameters penalties)
AIC, AICc, BIC, SABIC, CAIC, BCC
ECVI, ECVICI, MECVI, MECVICI

\strong{LISREL and other early fit indices} (we recommend not reporting these)
GFI, AGFI, PGFI, GH, NFI, PNFI, RFI

Want more? \emph{Open an Issue} at \href{https://github.com/tbates/umx/issues}{GitHub}.
}
\examples{
\dontrun{
library(umx)
data(demoOneFactor)
latents = c("G")
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor",
	data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
umxFitIndices(m1)

# And with raw data
m2 = umxRAM("m1", data = demoOneFactor,
	umxPath(latents, to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = latents)
)
umxFitIndices(m1, refModels = mxRefModels(m2, run = TRUE))
}

}
\seealso{
Other Reporting functions: 
\code{\link{RMSEA.MxModel}()},
\code{\link{RMSEA.summary.mxmodel}()},
\code{\link{RMSEA}()},
\code{\link{extractAIC.MxModel}()},
\code{\link{loadings}()},
\code{\link{residuals.MxModel}()},
\code{\link{tmx_show.MxMatrix}()},
\code{\link{tmx_show}()},
\code{\link{umxCI_boot}()},
\code{\link{umxCI}()},
\code{\link{umxConfint}()},
\code{\link{umxExpCov}()},
\code{\link{umxExpMeans}()},
\code{\link{umxRotate}()}
}
\author{
Brenton M. Wiernik, Athanassios Protopapas, Paolo Ghisletta, Markus Brauer
}
\concept{Reporting functions}
