% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_rename}
\alias{umx_rename}
\title{umx_rename}
\usage{
umx_rename(
  data,
  old = NULL,
  replace = NULL,
  regex = NULL,
  test = FALSE,
  grep = "deprecated"
)
}
\arguments{
\item{data}{The dataframe in which to rename variables}

\item{old}{List of old names that will be found and replaced by the contents of replace. (optional: Defaults to NULL).}

\item{replace}{If used alone, a named collection of c(oldName = "newName") pairs.
OR, if "old" is a list of existing names, the list of new names)
OR, if "regex" is a regular expression, the replace string)}

\item{regex}{Regular expression with matches will be replaced using replace as the replace string. (Optional: Defaults to NULL).}

\item{test}{Whether to report a "dry run", not changing anything. (Default = FALSE).}

\item{grep}{deprecated: use regex}
}
\value{
\itemize{
\item dataframe with columns renamed.
}
}
\description{
Returns a dataframe with variables renamed as desired.
}
\details{
Unlike similar functions in other packages, it checks that the variables exist, and that the new names do not.

Importantly, it also supports \link[=regex]{regular expressions}. This allows you to find and replace
text based on patterns and replacements. so to change "replacement" to "in place",
\verb{grep=re(place)ment}, \verb{replace= in \\\\1}.

\emph{note}:To use replace list, you must say c(old = "new"), not c(old -> "new")
}
\examples{
tmp = mtcars

tmp = umx_rename(tmp, replace = c(cyl = "cylinder"))
# let's check...
namez(tmp, "c")

# Alternate style: old<-replace, first with a test-run
# Dry run
tmp = umx_rename(tmp, old = c("disp"), replace = c("displacement"), test= TRUE)
tmp = umx_rename(tmp, old = c("disp"), replace = c("displacement"))
umx_check_names("displacement", data = tmp, die = TRUE)

# This will warn that "disp" does not exist (anymore)
new = c("displacement", "auto", "rear_axle_ratio")
tmp = umx_rename(tmp, old = c("am", "disp", "drat"), replace = new)
namez(tmp, "a") # still updated am to auto (and rear_axle_ratio)

# Test using regex (in this case to revert "displacement" to "disp")
tmp = umx_rename(tmp, regex = "lacement", replace = "", test= TRUE) 
tmp = umx_rename(tmp, regex = "lacement", replace = "") # revert to disp
umx_names(tmp, "^d") # all names beginning with a d

}
\seealso{
\link{namez} to filter (and replace) names, Also \link{umx_check_names} to check for existence of names in a dataframe.

Other Data Functions: \code{\link{umxHetCor}()},
  \code{\link{umx_as_numeric}()},
  \code{\link{umx_lower2full}()},
  \code{\link{umx_make_MR_data}()},
  \code{\link{umx_make_TwinData}()},
  \code{\link{umx_make_fake_data}()},
  \code{\link{umx_make_raw_from_cov}()},
  \code{\link{umx_polychoric}()},
  \code{\link{umx_polypairwise}()},
  \code{\link{umx_polytriowise}()},
  \code{\link{umx_read_lower}()},
  \code{\link{umx_reorder}()},
  \code{\link{umx_select_valid}()},
  \code{\link{umx_stack}()}, \code{\link{umx}},
  \code{\link{xmu_data_swap_a_block}()}
}
\concept{Data Functions}
