% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{GFF}
\alias{GFF}
\title{Twin data: General Family Functioning, divorce, and well-being.}
\format{A data frame with 1000 rows and 8 variables:}
\usage{
data(GFF)
}
\description{
Measures of family functioning, happiness and related variables in twins, and
their brothers and sisters. (see details)
}
\details{
Several scales in the data are described in  van der Aa et al. (2010).
General Family Functioning (GFF) refers to adolescents' evaluations general family health
vs. pathology. It assesses problem solving, communication, roles within the household,
affection, and control. GFF was assessed with a Dutch translation of the General Functioning
sub-scale of the McMaster Family Assessment Device (FAD) (Epstein et al., 1983).

Family Conflict (FC) refers to adolescents' evaluations of the amount of openly 
expressed anger, aggression, and conflict among family members. Conflict
sub-scale of the Family Environment Scale (FES) (Moos, 1974)

Quality of life in general (QLg) was assessed with the 10-step Cantril
Ladder from best- to worst-possible life (Cantril, 1965).

\describe{
  \item{zyg_6grp}{Six-level measure of zygosity: 'MZMM', 'DZMM', 'MZFF', 'DZFF', 'DZMF', 'DZFM'}
  \item{zyg_2grp}{Two-level measure of zygosity: 'MZ', 'DZ'}
  \item{divorce}{Parental divorce status: 0 = No, 1 = Yes}
  \item{sex_T1}{Sex of twin 1: 0 = "male", 1 = "female"}
  \item{age_T1}{Age of twin 1 (years)}
  \item{gff_T1}{General family functioning for twin 1}
  \item{fc_T1}{Family conflict sub-scale of the FES}
  \item{qol_T1}{Quality of life for twin 1}
  \item{hap_T1}{General happiness for twin 1}
  \item{sat_T1}{Satisfaction with life for twin 1}
  \item{AD_T1}{Anxiety and Depression for twin 1}
  \item{SOMA_T1}{Somatic complaints for twin 1}
  \item{SOC_T1}{Social problems for twin 1}
  \item{THOU_T1}{Thought disorder problems for twin 1}
  \item{sex_T2}{Sex of twin 2}
  \item{age_T2}{Age of twin 2}
  \item{gff_T2}{General family functioning for twin 2}
  \item{fc_T2}{Family conflict sub-scale of the FES}
  \item{qol_T2}{Quality of life for twin 2}
  \item{hap_T2}{General happiness for twin 2}
  \item{sat_T2}{Satisfaction with life for twin 2}
  \item{AD_T2}{Anxiety and Depression for twin 2}
  \item{SOMA_T2}{Somatic complaints for twin 2}
  \item{SOC_T2}{Social problems for twin 2}
  \item{THOU_T2}{Thought disorder problems for twin 2}
  \item{sex_Ta}{Sex of sib 1}
  \item{age_Ta}{Age of sib 1}
  \item{gff_Ta}{General family functioning for sib 1}
  \item{fc_Ta}{Family conflict sub-scale of the FES}
  \item{qol_Ta}{Quality of life for sib 1}
  \item{hap_Ta}{General happiness for sib 1}
  \item{sat_Ta}{Satisfaction with life for sib 1}
  \item{AD_Ta}{Anxiety and Depression for sib 1}
  \item{SOMA_Ta}{Somatic complaints for sib 1}
  \item{SOC_Ta}{Social problems for sib 1}
  \item{THOU_Ta}{Thought disorder problems for sib 1}
  \item{sex_Ts}{Sex of sib 2}
  \item{age_Ts}{Age of sib 2}
  \item{gff_Ts}{General family functioning for sib 2}
  \item{fc_Ts}{Family conflict sub-scale of the FES}
  \item{qol_Ts}{Quality of life for sib 2}
  \item{hap_Ts}{General happiness for sib 2}
  \item{sat_Ts}{Satisfaction with life for sib 2}
  \item{AD_Ts}{Anxiety and Depression for sib 2}
  \item{SOMA_Ts}{Somatic complaints for sib 2}
  \item{SOC_Ts}{Social problems for sib 2}
  \item{THOU_Ts}{Thought disorder problems for sib 2}
}
}
\examples{
# Twin 1 variables (end in '_T1')
data(GFF)
umx_names(GFF, "1$") # Just variables ending in 1 (twin 1)
str(GFF) # first few rows

m1 = umxACE(selDVs= "gff", sep = "_T",
	mzData = subset(GFF, zyg_2grp == "MZ"), 
	dzData = subset(GFF, zyg_2grp == "DZ")
)

}
\references{
van der Aa, N., Boomsma, D. I., Rebollo-Mesa, I., Hudziak, J. J., & Bartels, 
M. (2010). Moderation of genetic factors by parental divorce in adolescents' 
evaluations of family functioning and subjective wellbeing. Twin Research 
and Human Genetics, 13(2), 143-162. doi:10.1375/twin.13.2.143
}
\seealso{
Other datasets: \code{\link{iqdat}}, \code{\link{umx}},
  \code{\link{us_skinfold_data}}
}
\concept{datasets}
\keyword{datasets}
