% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxIP}
\alias{umxIP}
\title{umxIP: Build and run an Independent pathway twin model}
\usage{
umxIP(name = "IP", selDVs, dzData, mzData, sep = NULL, nFac = c(a =
  1, c = 1, e = 1), freeLowerA = FALSE, freeLowerC = FALSE,
  freeLowerE = FALSE, equateMeans = TRUE, dzAr = 0.5, dzCr = 1,
  correlatedA = FALSE, addStd = TRUE, addCI = TRUE,
  numObsDZ = NULL, numObsMZ = NULL,
  autoRun = getOption("umx_auto_run"), optimizer = NULL,
  suffix = "deprecated")
}
\arguments{
\item{name}{The name of the model (defaults to "IP").}

\item{selDVs}{The variables to include.}

\item{dzData}{The DZ dataframe.}

\item{mzData}{The MZ dataframe.}

\item{sep}{The suffix for twin 1 and twin 2, often "_T". If set, you can
omit suffixes in selDVs, i.e., just "dep" not c("dep_T1", "dep_T2").}

\item{nFac}{How many common factors for a, c, and e. If 1 number number is given, applies to all three.}

\item{freeLowerA}{Whether to leave the lower triangle of A free (default = FALSE).}

\item{freeLowerC}{Whether to leave the lower triangle of C free (default = FALSE).}

\item{freeLowerE}{Whether to leave the lower triangle of E free (default = FALSE).}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE).}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating).}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model).}

\item{correlatedA}{Whether factors are allowed to correlate (not implemented yet: FALSE).}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE).}

\item{addCI}{Whether to add the interval requests for CIs (defaults to TRUE).}

\item{numObsDZ}{= TODO: implement ordinal Number of DZ twins: Set this if you input covariance data,}

\item{numObsMZ}{= TODO: implement ordinal Number of MZ twins: Set this if you input covariance data.}

\item{autoRun}{Whether to mxRun the model (default TRUE: the estimated model will be returned).}

\item{optimizer}{optionally set the optimizer (default NULL does nothing).}

\item{suffix}{Deprecated: use "sep".}
}
\value{
- \code{\link{mxModel}}
}
\description{
Make a 2-group Independent Pathway twin model (Common-factor independent-pathway multivariate model)
The following figure shows the IP model diagrammatically:
\figure{IP.png}
}
\examples{
\dontrun{
require(umx)
data(GFF)
mzData <- subset(GFF, zyg_2grp == "MZ")
dzData <- subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff","fc","qol","hap","sat","AD") # These will be expanded into "gff_T1" "gff_T2" etc.
m1 = umxIP(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
m1 = umxIP(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData, 
	nFac = c(a=3, c = 1, e = 1)
)
umxSummary(m1)
plot(m1)
}
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCPold}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxEbiv}}, \code{\link{umxGxE}},
  \code{\link{umxIPnew}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
\concept{Twin Modeling Functions}
