% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxMatrix}
\alias{umxMatrix}
\title{Make a mxMatrix with automatic labels. Also takes name as the first parameter for more readable code.}
\usage{
umxMatrix(name = NA, type = "Full", nrow = NA, ncol = NA,
  free = FALSE, values = NA, labels = TRUE, lbound = NA, ubound = NA,
  byrow = getOption("mxByrow"), dimnames = NA,
  condenseSlots = getOption("mxCondenseMatrixSlots"), ...,
  joinKey = as.character(NA), joinModel = as.character(NA), jiggle = NA)
}
\arguments{
\item{name}{The name of the matrix (Default = NA). Note the different order compared to mxMatrix!}

\item{type}{The type of the matrix (Default = "Full")}

\item{nrow}{Number of rows in the matrix: Must be set}

\item{ncol}{Number of columns in the matrix: Must be set}

\item{free}{Whether cells are free (Default FALSE)}

\item{values}{The values of the matrix (Default NA)}

\item{labels}{Either whether to label the matrix (default TRUE), OR a vector of labels to apply.}

\item{lbound}{Lower bounds on cells (Defaults to NA)}

\item{ubound}{Upper bounds on cells (Defaults to NA)}

\item{byrow}{Whether to fill the matrix down columns or across rows first (Default = getOption('mxByrow')}

\item{dimnames}{NA}

\item{condenseSlots}{Whether to save memory by NULLing out unused matrix elements, like labels, ubound etc. Default = getOption('mxCondenseMatrixSlots')}

\item{...}{Additional parameters (!! not currently supported by umxMatrix)}

\item{joinKey}{See mxMatrix documentation: Defaults to as.character(NA)}

\item{joinModel}{See mxMatrix documentation: Defaults to as.character(NA)}

\item{jiggle}{= NA passed to umxLabel to jiggle start values (default does nothing)}
}
\value{
- \code{\link{mxMatrix}}
}
\description{
umxMatrix is a wrapper for mxMatrix which labels cells buy default, and has the name parameter first in order.
}
\examples{
umxMatrix("test", "Full", 1, 1)
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{mxMatrix}}, \code{\link{umxLabel}}, \code{\link{umxRAM}}

Other Core Modelling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxAlgebra}}, \code{\link{umxPath}},
  \code{\link{umxRAM}}, \code{\link{umxRun}},
  \code{\link{umxSuperModel}}, \code{\link{umx}}
}
