% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxCompare}
\alias{umxCompare}
\title{umxCompare}
\usage{
umxCompare(base = NULL, comparison = NULL, all = TRUE, digits = 3,
  report = c("2", "1", "html"), file = "tmp.html")
}
\arguments{
\item{base}{The base \code{\link{mxModel}} for comparison}

\item{comparison}{The model (or list of models) which will be compared for fit with the base model (can be empty)}

\item{all}{Whether to make all possible comparisons if there is more than one base model (defaults to T)}

\item{digits}{rounding for p etc.}

\item{report}{Optionally (report = "2") add sentences for inclusion in a paper, or ("html")
create a web table and open your default browser.
(handy for getting tables into Word, and other text systems!)}

\item{file}{file to write html too if report=3 (defaults to "tmp.html")}
}
\description{
umxCompare compares two or more \code{\link{mxModel}}s. It has several nice features:
1. It supports direct control of rounding, and reports p-values rounded to APA style.
2. It reports the table in your preferred markdown format (relies on knitr)
3. The table columns are arranged in a method suitable for easy comparison for readers.
4. By default, it also reports the output as an ENglish sentence suitable for a paper.
5. It can open tabular output in a browser (report = "html")
}
\details{
note: If you leave comparison blank, it will just give fit info for the base model
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m2 = umxModify(m1, update = "G_to_x2", name = "drop_path_2_x2")
umxCompare(m1, m2)
mxCompare(m1, m2) # what OpenMx gives by default
umxCompare(m1, m2, report = "2") # Add English-sentence descriptions
\dontrun{
umxCompare(m1, m2, report = "html") # Open table in browser
}
m3 = umxModify(m2, update = "G_to_x3", name = "drop_path_2_x2_and_3")
umxCompare(m1, c(m2, m3))
umxCompare(c(m1, m2), c(m2, m3), all = TRUE)
}
\references{
- \url{http://www.github.com/tbates/umx/}
}
\seealso{
- \code{\link{mxCompare}}, \code{\link{umxSummary}}, \code{\link{umxRAM}},

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACE}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

